*! version 5.0
* 13 August 2018
* NIDS
* Master Wealth do file updated for Nids Wave 4

* THIS IS 5th WEALTH DO FILE - IMPUTATION AGGREGATION DO FILE: 5 OF 6
* THIS DO FILE AGGREGATES THE IMPUTATION WEALTH VARIABLES

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Wealth do file (1 of 6)"

version 13.0

*=====================================================================================================================================

* OPENING DATASET PREPARED IN PRIOR DO FILE "Wealth - Performing Imputations on Wealth varaibles (4 of 6).do"

set more off

use "$DataOUT\impdata.dta", clear

*-------------------------------------------------------------------------------------------------------------------------------------
***HOUSEHOLD LEVEL AGGREGATIONS***
*-------------------------------------------------------------------------------------------------------------------------------------

************************
*Unit non-response rate*
************************

sort w4_hhid
egen hhunitR=sum(response), by(w4_hhid)
cap drop temp
gen temp=1 if pid!=.
egen hhsize_adult=count(temp), by(w4_hhid)
drop temp
gen hhunitNRR=1-(hhunitR/hhsize_adult)
recode hhunitNRR (0=0 "0%") (0.0001/0.24999=1 "0%-25%") (0.25/0.4999=2 "25% - 49%") ///
(0.5/0.74999=3 "50% - 74%") (0.75/0.999=4 "75% - 100%") (1=5 "100%"), gen(hhunitNRR_6)

*-------------------------------------------------------------------------------

//PRE-IMPUTATION AGGREGATION ****

	egen pi_re_ass=rowtotal(houseval otherhouseval), mi
	egen pi_re_deb=rowtotal(housedebt otherhousedebt), mi

	egen pi_lvstk_ass=rowtotal(cattle sheep goats pigs horses donkeys chickens), m

	* Business Assets

	sort w4_hhid
	by w4_hhid: egen pi_b_ass=sum(busass)

	* Vehicle Assets

	sort w4_hhid
	by w4_hhid: egen temp1=sum(priveh)
	by w4_hhid: egen temp3=sum(scooter)
	egen pi_v_ass=rowtotal(temp1 temp3), mi
	drop temp*

	* Financial Assets

	sort w4_hhid
	by w4_hhid: egen temp2=sum(bank)
	by w4_hhid: egen temp4=sum(stocks)
	egen pi_f_ass=rowtotal(temp*), m
	drop temp*

	* Retirement Plan

	sort w4_hhid
	by w4_hhid: egen pi_s_ass=sum(pension)

	* Possessions
	clonevar pi_p_ass=posses

	* Business Debt

	sort w4_hhid 
	by w4_hhid: egen pi_b_deb=sum(busdeb)

	* Vehicle Debt

	sort w4_hhid
	by w4_hhid: egen pi_v_deb=sum(vehdebt)

	* Financial Debt

	sort w4_hhid
	foreach var of varlist bankoverdraft bankdebt micro masho studentloan otherstudentloan creditcard ///
	store hirep famloan friendloan emploan unpaidtax arrears dtother1 dtother2{
	by w4_hhid: egen temp`var'=sum(`var')
	}
	egen pi_f_deb=rowtotal(temp*), m
	drop temp*


*-------------------------------------------------------------------------------

//POST-IMPUTATION AGGREGATION ****

	egen re_ass=rowtotal(houseval_imp otherhouseval_imp), mi
	egen re_deb=rowtotal(housedebt_imp otherhousedebt_imp), mi

	egen lvstk_ass=rowtotal(cattle_imp sheep_imp goats_imp pigs_imp horses_imp donkeys_imp chickens_imp), mi

	* Business Assets
	sort w4_hhid
	by w4_hhid: egen b_ass=sum(busass_imp)

	* Vehicle Assets
	sort w4_hhid
	by w4_hhid: egen temp1=sum(priveh_imp)
	by w4_hhid: egen temp3=sum(scooter_imp)
	egen v_ass=rowtotal(temp1 temp3), mi
	drop temp*

	* Financial Assets
	sort w4_hhid
	by w4_hhid: egen temp2=sum(bank_imp)
	by w4_hhid: egen temp4=sum(stocks_imp)
	egen f_ass=rowtotal(temp*), m
	drop temp*

	* Retirement Plan
	sort w4_hhid
	by w4_hhid: egen s_ass=sum(pension_imp)

	* Business Debt
	sort w4_hhid 
	by w4_hhid: egen b_deb=sum(busdeb_imp)

	*  Vehicle Debt
	sort w4_hhid
	by w4_hhid: egen v_deb=sum(vehdebt_imp)

	* Financial Debt
	sort w4_hhid
	foreach var of varlist bankoverdraft bankdebt_imp micro_imp masho_imp studentloan_imp ///
	otherstudentloan_imp creditcard_imp store_imp hirep_imp famloan_imp ///
	friendloan_imp emploan_imp unpaidtax_imp arrears_imp dtother1_imp dtother2_imp{
	by w4_hhid: egen temp`var'=sum(`var')
	}
	egen f_deb=rowtotal(temp*), m
	drop temp*

	* Possessions
	clonevar p_ass=posses_imp

	foreach var of varlist pi_re_ass pi_b_ass pi_v_ass pi_f_ass pi_s_ass pi_p_ass pi_lvstk_ass pi_re_deb pi_b_deb pi_v_deb pi_f_deb re_ass b_ass v_ass f_ass s_ass lvstk_ass p_ass re_deb b_deb v_deb f_deb{
	replace `var'=. if `var'==0
	replace `var'=. if hhunitNRR>0 & hhq_networth!=.
	}

	/*So now we have set the components of net worth equal to missing for those HHs with
	partial unit non-response AND valid one-shot net worth. Those HHs with PUNR and missing
	one-shot net-worth will have the components summed over the available adults, as outlined
	in the user document.*/

	*-------------------------------------------------------------------------------

//AGGREGATING UP TO THE HOUSEHOLD LEVEL

	egen pi_tot_ass=rowtotal(pi_re_ass pi_b_ass pi_v_ass pi_f_ass pi_s_ass pi_p_ass pi_lvstk_ass), m
	egen pi_tot_deb=rowtotal(pi_re_deb pi_b_deb pi_v_deb pi_f_deb), m
	egen tot_ass=rowtotal(re_ass b_ass v_ass f_ass s_ass lvstk_ass p_ass), m
	egen tot_deb=rowtotal(re_deb b_deb v_deb f_deb), m

	gen temp1=-(pi_tot_deb)
	gen temp2=-(tot_deb)

	egen pi_net_worth=rowtotal(pi_tot_ass temp1), m
	egen net_worth=rowtotal(tot_ass temp2), m
	drop temp*

	replace net_worth=hhq_networth if net_worth==. & hhq_networth!=.

	sort w4_hhid
	drop if w4_hhid==w4_hhid[_n-1]

save "$DataOUT\hhwealth.dta", replace


*-------------------------------------------------------------------------------------------------------------------------------------
***INDIVIDUAL LEVEL AGGREGATIONS***
*-------------------------------------------------------------------------------------------------------------------------------------


use "$DataOUT\impdata.dta", clear

//PRE-IMPUTATION AGGREGATION 

	* Business Assets
	clonevar  pi_b_ass_i = busass

	* Vehicle Assets
	egen pi_v_ass_i =rowtotal(priveh scooter), mi //bakkie


	* Financial Assets
	egen pi_f_ass_i =rowtotal(bank stocks), m

	* Property assets
	gen pi_h_ass_i=propvalue*(ownpidpo1/100) if ownpid1==pid
	replace pi_h_ass_i=propvalue*(ownpidpo2/100) if ownpid2==pid
	replace pi_h_ass_i=propvalue*(ownpidpo3/100) if ownpid3==pid

	gen adult = 1 if best_age_yrs >=16 & best_age_yrs<=110 //divide value of property by all adults in household
	egen hhadults = sum(adult), by(w4_hhid)

	gen pi_otre_ass_i=otherpropvalue*(ownpidpo1/100) if ownpid1==pid
	replace pi_otre_ass_i=otherpropvalue*(ownpidpo2/100) if ownpid2==pid
	replace pi_otre_ass_i=otherpropvalue*(ownpidpo3/100) if ownpid3==pid // divide value of property by proportion of ownership of main dwelling

	gen hhead = 1 if head==pid 
	replace pi_otre_ass_i=otherpropvalue if hhead==1 & ownoth ==1 & ownd == 2  // allocate entire value of property to household head as default if the house does not own main house but owns other property

	*gen pi_otre_ass_i=otherpropvalue/hhadults

	egen pi_re_ass_i = rowtotal(pi_h_ass_i pi_otre_ass_i)

	* Retirement Plan
	clonevar pi_s_ass_i=pension

	* Household Possessions
	clonevar pi_p_ass_i=posses_i

	* Business Debt
	clonevar pi_b_deb_i=busdeb

	* Vehicle Debt
	clonevar pi_v_deb_i=vehdebt 

	* Financial Debt

	sort w4_hhid
	egen pi_f_deb_i = rowtotal( bankoverdraft bankdebt micro masho studentloan otherstudentloan creditcard ///
	store hirep famloan friendloan emploan unpaidtax arrears dtother1 dtother2), m

	* Household debt

	clonevar pi_h_deb_i=bondowing_i

	gen pi_otre_deb_i=otherhousedebt*(ownpidpo1/100) if ownpid1==pid
	replace pi_otre_deb_i=otherhousedebt*(ownpidpo2/100) if ownpid2==pid
	replace pi_otre_deb_i=otherhousedebt*(ownpidpo3/100) if ownpid3==pid // divide other debt owing by proportion of ownership of main dwelling

	replace pi_otre_ass_i=otherhousedebt if hhead==1 & ownothpaid==2 & ownd ==2 // allocate entire value of other debt to household head if hh does not own main house but has other house debt

	*gen pi_otre_deb_i=otherhousedebt/hhadults

	egen pi_re_deb_i=rowtotal(pi_h_deb_i pi_otre_deb_i), mi

*-------------------------------------------------------------------------------

//POST-IMPUTATION AGGREGATION ****                            

	* Business Assets
	clonevar b_ass_i=busass_imp

	* Vehicle Assets
	egen v_ass_i =rowtotal(priveh_imp scooter_imp), mi //bakkie_imp

	* Financial Assets
	egen f_ass_i=rowtotal(bank_imp stocks_imp), mi //cash_imp life_imp

	* Property assets
	gen h_ass_i=houseval*(ownpidpo1/100) if ownpid1==pid
	replace h_ass_i=houseval*(ownpidpo2/100) if ownpid2==pid
	replace h_ass_i=houseval*(ownpidpo3/100) if ownpid3==pid

	gen otre_ass_i=otherhouseval*(ownpidpo1/100) if ownpid1==pid
	replace otre_ass_i=otherhouseval*(ownpidpo2/100) if ownpid2==pid
	replace otre_ass_i=otherhouseval*(ownpidpo3/100) if ownpid3==pid // divide value of property by proportion of ownership of main dwelling

	replace otre_ass_i=otherhouseval if hhead==1 & ownoth ==1 & ownd == 2 // allocate entire value of property to household head as default if the house does not own main house but owns other property
	
	*gen otre_ass_i=otherhouseval/hhadults //divide value of property by all adults in household
	
	egen re_ass_i = rowtotal(h_ass_i otre_ass_i), mi 

	* Retirement Plan
	egen s_ass_i = rowtotal(pension_imp), mi //clonevar s_ass_i=pension_imp

	* Household Posessions
	egen p_ass_i = rowtotal(posses_i_imp), mi //clonevar p_ass_i=posses_i_imp

	* Business Debt
	egen b_deb_i = rowtotal(busdeb_imp), mi //clonevar b_deb_i=busdeb_imp

	*  Vehicle Debt
	egen v_deb_i = rowtotal(vehdebt_imp), mi //clonevar v_deb_i=vehdebt_imp

	* Financial Debt
	egen f_deb_i=rowtotal(bankoverdraft bankdebt_imp micro_imp masho_imp studentloan_imp ///
	otherstudentloan_imp creditcard_imp store_imp hirep_imp famloan_imp ///
	friendloan_imp emploan_imp unpaidtax_imp arrears_imp dtother1_imp dtother2_imp), mi

	* Household Debt

	clonevar h_deb_i=bondowing_i_imp

	gen otre_deb_i=otherhousedebt_imp*(ownpidpo1/100) if ownpid1==pid
	replace otre_deb_i=otherhousedebt_imp*(ownpidpo2/100) if ownpid2==pid
	replace otre_deb_i=otherhousedebt_imp*(ownpidpo3/100) if ownpid3==pid // divide other debt owing by proportion of ownership of main dwelling

	replace otre_ass_i=otherhousedebt_imp if hhead==1 & ownothpaid==2 & ownd ==2 // allocate entire value of other debt to household head if hh does not own main house but has other house debt
	
	*gen otre_deb_i=otherhousedebt_imp/hhadults
	
	egen re_deb_i=rowtotal(h_deb_i otre_deb_i), mi

*-------------------------------------------------------------------------------

//AGGREGATING UP TO THE INDIVIDUAL LEVEL

	egen pi_tot_ass_i=rowtotal(pi_b_ass_i pi_v_ass_i pi_f_ass_i pi_s_ass_i pi_re_ass_i pi_p_ass_i), m
	egen pi_tot_deb_i=rowtotal(pi_b_deb_i pi_v_deb_i pi_f_deb_i pi_re_deb_i), m
	egen tot_ass_i=rowtotal(b_ass_i v_ass_i f_ass_i s_ass_i re_ass_i p_ass_i), m
	egen tot_deb_i=rowtotal(b_deb_i v_deb_i f_deb_i re_deb_i), m

	gen temp1=-(pi_tot_deb_i)
	gen temp2=-(tot_deb_i)

	egen pi_net_worth_i=rowtotal(pi_tot_ass_i temp1), m
	egen net_worth_i=rowtotal(tot_ass_i temp2), m
	drop temp*

save "$DataOUT\indwealth.dta", replace

//end of do file
*===================================================================================================================================
